#!/bin/bash

HOST_TZ=$(timedatectl show --property=Timezone --value 2>/dev/null || cat /etc/timezone 2>/dev/null || echo "UTC")
exec /usr/bin/podman run \
        --cgroups=no-conmon \
        --rm \
        --sdnotify=conmon \
        --replace \
        -d \
        --tz=local \
        --name dhcs-portal \
        --network=host \
        -e JAVA_TOOL_OPTIONS="-Dfile.encoding=UTF-8 -Duser.timezone=$HOST_TZ" \
        -p 8020:8020 \
        -v /data/dhcs:/data/dhcs \
        -v /sys/firmware/dmi/tables/DMI:/data/init/DMI \
        -v /data/dahu:/data/dahu dhcs-portal:latest