#!/bin/bash

HOST_TZ=$(timedatectl show --property=Timezone --value 2>/dev/null || cat /etc/timezone 2>/dev/null || echo "UTC")
exec /usr/bin/podman run \
        --cgroups=no-conmon \
        --rm \
        --sdnotify=conmon \
        --replace \
        -d \
        --tz=local \
        --name dhcs-broker \
        --network=host \
        -e JAVA_TOOL_OPTIONS="-Dfile.encoding=UTF-8 -Duser.timezone=$HOST_TZ" \
        -v /data/emqx/data/configs/cluster.hocon:/data/emqx/data/configs/cluster.hocon \
        -v /data/emqx/etc/base.hocon:/data/emqx/etc/base.hocon \
        -v /data/emqx/etc/default_api_key.conf:/data/emqx/etc/default_api_key.conf \
        -v /data/emqx/etc/emqx.conf:/data/emqx/etc/emqx.conf \
        -v /data/emqx/log:/data/emqx/log \
        -v /data/auth:/data/auth dhcs-broker:latest