#!/bin/bash

#设置时区

chmod -R 755 ../
echo "System optimization settings"
chmod +x ./scripts/*.sh
./scripts/sys-optz.sh
mv ./scripts/*-start.sh /usr/local/bin

echo "System image import"

cd images
tar -xf dhcs-images.tar.*
podman load -i portal.tar
podman load -i broker.tar
podman load -i proxy.tar
podman load -i store.tar

rm -rf portal.tar broker.tar proxy.tar store.tar

cd ..

mkdir -p /data
mv data/* /data/

echo "Install systemd services"
mv services/* /lib/systemd/system
systemctl enable container-dhcs-store
systemctl enable container-dhcs-broker
systemctl enable container-dhcs-proxy
systemctl enable container-dhcs-portal

echo "Start the dhcs-store service"
systemctl start container-dhcs-store
sleep 5

cd /data/init
echo "Initialize the system installation configuration file"
./init-config.sh

MODEL_INIT_EXCEL="/data/init/model_init.xlsx"
if [ -f "$MODEL_INIT_EXCEL" ]; then
    python3 model_excel.py
    sleep 2
    rm -rf MODEL_INIT_EXCEL
else
    echo "Warn: Unable to find $MODEL_INIT_EXCEL!"
fi


cd /data/init
echo "Initialize Database"
chmod +x /data/init/init-store.sh
#需要在容器内去初始化，宿主机没有相关命令
podman exec dhcs-store /data/init/init-store.sh

echo "Configure the application package"
python3 update_jar.py

echo "Start the dhcs-broker service"
systemctl start container-dhcs-broker

sleep 3

echo "Start the dhcs-proxy service"
systemctl start container-dhcs-proxy

sleep 3

echo "Start the dhcs-portal service"
systemctl start container-dhcs-portal

echo "DHCS installation completed"
echo "HTTP：http://IP|domain"
echo "HTTPS：https://IP|domain, Default self-signed certificate directory：data\etc\nginx\ssl\site"
