import zipfile
import re
import uuid
import html

def excel_to_sql(xlsx_file, sql_file='model_init.sql'):
    with zipfile.ZipFile(xlsx_file, 'r') as z:
        with z.open('xl/worksheets/sheet1.xml') as f:
            xml = f.read().decode('utf-8')
            
            cells = []
            
            pattern = r'<c[^>]+r="([A-Z]+)(\d+)"[^>]*>(.*?)</c>'
            matches = re.findall(pattern, xml, re.DOTALL)
            
            for col_letter, row_num, content in matches:
                row = int(row_num)
                col = col_letter
                
                value = ''
                
                t_match = re.search(r'<t[^>]*>(.*?)</t>', content, re.DOTALL)
                if t_match:
                    value = html.unescape(t_match.group(1))
                else:
                    # 尝试提取<v>标签
                    v_match = re.search(r'<v>(.*?)</v>', content)
                    if v_match:
                        value = v_match.group(1)
                
                cells.append((row, col, value))
            
            cells.sort(key=lambda x: (x[0], x[1]))
            
            max_row = max(c[0] for c in cells) if cells else 0
            col_letters = sorted(set(c[1] for c in cells))
            
            table = {}
            for row, col, value in cells:
                if row not in table:
                    table[row] = {}
                table[row][col] = value
            
            # 生成SQL（假设第1行是标题，A-E列对应各字段）
            inserts = []
            for row in range(2, max_row + 1):
                if row in table:
                    # 获取A-E列的值
                    model = table[row].get('A', '')
                    mac_str = table[row].get('B', '')
                    platform = table[row].get('C', '')
                    panel_config = table[row].get('D', '')
                    remark = table[row].get('E', '')
                    
                    # 生成SQL
                    row_id = uuid.uuid4().hex
                    
                    try:
                        mac_value = int(float(mac_str)) if mac_str else 'NULL'
                    except:
                        mac_value = 'NULL'
                    
                    def esc(s):
                        return str(s).replace("'", "''")
                    
                    sql = f"INSERT INTO t_dahu_base_model (id, b_model, mac_num, platform, layout, remark, create_time) VALUES ('{row_id}', '{esc(model)}', {mac_value}, '{esc(platform)}', '{esc(panel_config)}', '{esc(remark)}', now());"
                    inserts.append(sql)
            
            # 保存
            if inserts:
                with open(sql_file, 'w', encoding='utf-8') as f:
                    f.write('\n'.join(inserts))
                print(f"Generate {len(inserts)} initialization SQL statements.")
            else:
                print("Excel init-models empty.")

excel_to_sql('model_init.xlsx')