#!/bin/bash

set -e
ENV_CONF="/data/init/build_env.conf"
DHCS_INIT_SQL="/data/init/dhcs.sql"

MODEL_INIT_SQL="/data/init/model_init.sql"

MYSQL_ROOT_PASSWORD="Shra12#$"
MYSQL_APP_USER=$(grep -oP 'spring.datasource.druid.username=\K.*' "$ENV_CONF")
MYSQL_APP_PASSWORD=$(grep -oP 'spring.datasource.druid.password=\K.*' "$ENV_CONF")
MYSQL_APP_DATABASE="dhcs"

FRP_CONFIG=$(grep -oP 'sys.frps.proxy=\K.*' "$ENV_CONF")

INFLUXDB_ADMIN_USER="admin"
INFLUXDB_ADMIN_PASSWORD="Shra12#$"
INFLUXDB_ORG=$(grep -oP 'influx.org=\K.*' "$ENV_CONF")
INFLUXDB_TOKEN=$(grep -oP 'influx.token=\K.*' "$ENV_CONF")

echo "DHCS Initialization"

# 等待 MySQL 启动
wait_for_mysql() {
    echo "Waiting for MySQL to be ready..."
    for i in {1..30}; do
        if mysqladmin ping -h localhost --silent; then
            return 0
        fi
        echo "Waiting for MySQL... ($i/30)"
        sleep 2
    done
    echo "ERROR: MySQL failed to start within timeout"
    exit 1
}

wait_for_mysql

echo "Creating databases and users..."

mysql -u root <<-EOSQL
    -- 设置 root 密码
    ALTER USER 'root'@'localhost' IDENTIFIED WITH caching_sha2_password BY '${MYSQL_ROOT_PASSWORD}';
    
    -- 创建数据库
    CREATE DATABASE IF NOT EXISTS ${MYSQL_APP_DATABASE};
    
    -- 创建应用用户
    CREATE USER IF NOT EXISTS '${MYSQL_APP_USER}'@'%' IDENTIFIED BY '${MYSQL_APP_PASSWORD}';
    CREATE USER 'export'@'local' IDENTIFIED BY 'dahu@123';
    
    -- 授权
    GRANT ALL PRIVILEGES ON ${MYSQL_APP_DATABASE}.* TO '${MYSQL_APP_USER}'@'%';
    GRANT ALL PRIVILEGES ON ${MYSQL_APP_DATABASE}.* TO 'export'@'local';
    FLUSH PRIVILEGES;
EOSQL

# 还原数据库
echo "Initialization of the database."

export MYSQL_PWD="${MYSQL_ROOT_PASSWORD}"
mysql -uroot dhcs < $DHCS_INIT_SQL

if [ -f "$MODEL_INIT_SQL" ]; then
  mysql -uroot dhcs < $MODEL_INIT_SQL
fi

mysql -uroot dhcs <<EOF
UPDATE sys_config SET config_value='${FRP_CONFIG}' WHERE config_key='sys.frps.proxy';
EOF
unset MYSQL_PWD

rm -rf $MODEL_INIT_SQL
rm -rf model_excel.py
rm -rf $DHCS_INIT_SQL

echo "MySQL initialization completed successfully"
echo "Setting up InfluxDB..."
influx setup \
    --username "${INFLUXDB_ADMIN_USER}" \
    --password "${INFLUXDB_ADMIN_PASSWORD}" \
    --org "${INFLUXDB_ORG}" \
    --token "${INFLUXDB_TOKEN}" \
    --bucket "default" \
    --force
echo "InfluxDB setup completed"