#!/bin/bash

# 生成随机值
FRP_TOKEN=$(tr -dc 'a-zA-Z0-9' < /dev/urandom | head -c 32)
DB_USERNAME="$(tr -dc 'a-zA-Z0-9' < /dev/urandom | head -c 8)"
DB_PASSWORD="$(tr -dc 'a-zA-Z0-9' < /dev/urandom | head -c 1)$(tr -dc 'a-zA-Z0-9@#$%' < /dev/urandom | head -c 9)d!"
MQTT_SECRET=$(tr -dc 'a-zA-Z0-9' < /dev/urandom | head -c 30)
API_KEY=$(tr -dc 'a-zA-Z0-9' < /dev/urandom | head -c 14)
API_SECRET=$(tr -dc 'a-zA-Z0-9' < /dev/urandom | head -c 32)
TOKEN_SECRET=$(tr -dc 'a-zA-Z0-9' < /dev/urandom | head -c 30)
INFLUX_TOKEN=$(tr -dc 'a-zA-Z0-9' < /dev/urandom | head -c 1)$(tr -dc 'a-zA-Z0-9=+' < /dev/urandom | head -c 31)

# 生成安装配置文件build_env.conf文件(此文件非常重要，后续升级都需要用到)
cat > /data/init/build_env.conf << EOF
sys.frps.proxy={"ip":"127.0.0.1", "port":"6000-6100","token":"$FRP_TOKEN"}
spring.datasource.druid.username=$DB_USERNAME
spring.datasource.druid.password=$DB_PASSWORD

mqtt.super-secret=$MQTT_SECRET
mqtt.api-key=$API_KEY
mqtt.api-secret=$API_SECRET

token.secret=$TOKEN_SECRET
influx.org=dhcs
influx.bucket=default
influx.token=$INFLUX_TOKEN
EOF

echo "Create the MQTT-API key file to /data/emqx/etc/"
cat > /data/emqx/etc/default_api_key.conf <<EOF
${API_KEY}:${API_SECRET}
EOF

cat > /data/init/frps.toml <<EOF
bindPort = 7000
#log.to = "/data/frps/log/frps.log"
#log.level = "debug"
#log.maxDays = 3
webServer.addr = "0.0.0.0"
webServer.port = 5002
webServer.user = "admin"
webServer.password = "Shra12#$"
auth.token = "$FRP_TOKEN"
EOF

echo "The installation configuration file has been generated. Please do not modify, delete or move this file! config:/data/init/build_env.conf"