/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.ip.service;

import com.hohunet.cache.IpLocationCache;
import com.hohunet.common.utils.StringUtils;
import com.hohunet.common.utils.ip.IpUtils;
import com.hohunet.ip.service.IpLocalDBGeo;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class IpLocationService {
    @Value(value="${hohunet.geo-file}")
    private String geoDBFile;

    public String geoLocation(String ip) {
        if (StringUtils.isEmpty((String)ip)) {
            return "";
        }
        return this.reqGeoLocation(ip);
    }

    private String reqGeoLocation(String ip) {
        String location = IpLocationCache.getLocation((String)ip);
        if (!StringUtils.isEmpty((String)location)) {
            return location;
        }
        location = this.reqOpenApiLocation(ip);
        IpLocationCache.setLocation((String)ip, (String)location);
        return location;
    }

    private String reqOpenApiLocation(String ip) {
        String city = IpLocalDBGeo.getCity((String)ip);
        if (StringUtils.isEmpty((String)city) && IpUtils.internalIp((String)ip)) {
            return "Intranet";
        }
        return city;
    }

    @PostConstruct
    public void initLocationGeo() throws IOException {
        IpLocalDBGeo.getInstance().build(this.geoDBFile);
    }
}

