/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.ip.service;

import com.hohunet.ip.domain.GeoLocation;
import com.maxmind.db.Reader;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpLocalDBGeo {
    private static final Logger log = LoggerFactory.getLogger(IpLocalDBGeo.class);
    private static volatile IpLocalDBGeo ipLocalGeo;
    private static Reader reader;

    private IpLocalDBGeo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IpLocalDBGeo getInstance() {
        if (ipLocalGeo != null) return ipLocalGeo;
        Class<IpLocalDBGeo> clazz = IpLocalDBGeo.class;
        synchronized (IpLocalDBGeo.class) {
            if (ipLocalGeo != null) return ipLocalGeo;
            ipLocalGeo = new IpLocalDBGeo();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ipLocalGeo;
        }
    }

    public void build(String dbFile) throws IOException {
        reader = new Reader(new File(dbFile));
    }

    public static String getCity(String ip) {
        try {
            InetAddress ipAddress = InetAddress.getByName(ip);
            GeoLocation location = (GeoLocation)reader.get(ipAddress, GeoLocation.class);
            if (location != null) {
                String country = location.getCountry();
                String city = location.getCity();
                return city + "/" + country;
            }
        }
        catch (Exception e) {
            log.error("get city error", (Throwable)e);
        }
        return "";
    }
}

