/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.emqx.service;

import com.alibaba.fastjson2.JSON;
import com.hohunet.common.utils.SignUtils;
import com.hohunet.common.utils.StringUtils;
import com.hohunet.emqx.domain.MqttAuthorResult;
import com.hohunet.emqx.domain.SnConnectInfo;
import com.hohunet.emqx.service.AbstractModelService;
import com.hohunet.emqx.service.CloudMgtDeviceService;
import com.hohunet.emqx.service.MqttRestClientService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class MqttStandModelService
extends AbstractModelService {
    private static Logger logger = LoggerFactory.getLogger(MqttStandModelService.class);
    private static final Map<String, String> DOMAIN_ACL_TEMPLATE = new HashMap();
    @Autowired
    private CloudMgtDeviceService cloudMgtDeviceService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private MqttRestClientService mqttRestClientService;

    public MqttAuthorResult domainModeAuth(String user, String sn, String product, String mac, String method, String signContent, String password, String clientId) {
        SnConnectInfo connectInfo = this.cloudMgtDeviceService.findCloudMgtDeviceConnectInfo(sn, mac = mac.toUpperCase());
        if (connectInfo == null || StringUtils.isEmpty((String)connectInfo.getSecret())) {
            return this.denyResult();
        }
        String sign = SignUtils.encrypt((String)signContent, (String)connectInfo.getSecret(), (String)method);
        if (sign.equals(password)) {
            if (!StringUtils.isEmpty((String)connectInfo.getClientId()) && !clientId.equals(connectInfo.getClientId())) {
                this.mqttRestClientService.kickClientId(connectInfo.getClientId());
            }
            this.grantDomainACL(user, product, sn);
            return this.allowResult(false);
        }
        return this.denyResult();
    }

    private void grantDomainACL(String user, String product, String sn) {
        String aclKey;
        if (DOMAIN_ACL_TEMPLATE.isEmpty()) {
            this.initAclTemplate();
        }
        if (this.redisTemplate.hasKey((Object)(aclKey = "mqtt_acl:" + user)).booleanValue()) {
            this.redisTemplate.persist((Object)aclKey);
            return;
        }
        if (!this.redisTemplate.hasKey((Object)product).booleanValue()) {
            HashMap<String, String> hashAcl = new HashMap<String, String>(DOMAIN_ACL_TEMPLATE.size() * 2);
            for (Map.Entry entry : DOMAIN_ACL_TEMPLATE.entrySet()) {
                hashAcl.put(String.format((String)entry.getKey(), product, sn), (String)entry.getValue());
            }
            BoundHashOperations hashOperations = this.redisTemplate.boundHashOps((Object)aclKey);
            hashOperations.putAll(hashAcl);
            this.redisTemplate.persist((Object)aclKey);
        }
    }

    private void initAclTemplate() {
        InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("acl/domain.acl");
        if (inStream != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));){
                String aclDefine;
                while ((aclDefine = reader.readLine()) != null) {
                    aclDefine = this.charEmpty(aclDefine);
                    String[] aclProps = aclDefine.split("=");
                    MqttAuthorResult.Acl aclObject = (MqttAuthorResult.Acl)JSON.parseObject((String)aclProps[1], MqttAuthorResult.Acl.class);
                    if (aclProps.length != 2 || aclProps[0] == null) {
                        throw new RuntimeException("domain_acl file configure formatter error, eg:topic={acl}!!");
                    }
                    if (aclObject.getAction() == null) {
                        throw new RuntimeException("domain_acl file configure error, missing 'action'!!");
                    }
                    DOMAIN_ACL_TEMPLATE.put(aclProps[0], aclProps[1]);
                }
                inStream.close();
            }
            catch (IOException e) {
                logger.error("loader domain_acl file error", (Throwable)e);
            }
        }
    }
}

