/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.emqx.service;

import com.alibaba.fastjson2.JSON;
import com.hohunet.emqx.domain.ClientResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class MqttRestClientService {
    private static Logger logger = LoggerFactory.getLogger(MqttRestClientService.class);
    @Value(value="${mqtt.api-addr}")
    private String apiAddr;
    @Value(value="${mqtt.api-key}")
    private String apiKey;
    @Value(value="${mqtt.api-secret}")
    private String apiSecret;
    private static String apiToken;
    private static final String KICK_OUT_CLIENT_API = "/api/v5/clients/kickout/bulk";
    private static final String CLIENT_API = "/api/v5/clients/";
    @Autowired
    private RestTemplate restTemplate;

    private String getApiToken() {
        if (apiToken == null) {
            String credentials = this.apiKey + ":" + this.apiSecret;
            apiToken = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
        }
        return apiToken;
    }

    public void kickClientId(String clientId) {
        String[] clients = new String[]{clientId};
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Basic " + this.getApiToken());
        HttpEntity entity = new HttpEntity((Object)JSON.toJSONString((Object)clients), (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.apiAddr + KICK_OUT_CLIENT_API, HttpMethod.POST, entity, String.class, new Object[0]);
        if (204 == response.getStatusCode().value()) {
            logger.warn("kick out connection {}", (Object)clientId);
        }
    }

    public boolean checkClientStatus(String clientId) {
        String url = this.apiAddr + CLIENT_API + clientId;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Basic " + this.getApiToken());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, ClientResponse.class, new Object[0]);
        return response.getBody() != null && ((ClientResponse)response.getBody()).isConnected();
    }
}

