/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.emqx.service;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hohunet.emqx.connect.cache.ConnectLazyState;
import com.hohunet.emqx.connect.domain.ConnectCheck;
import com.hohunet.emqx.connect.domain.ConnectState;
import com.hohunet.emqx.domain.ConnectionRequest;
import com.hohunet.emqx.domain.ConnectionStatus;
import com.hohunet.emqx.mapper.CloudMgtDeviceMapper;
import com.hohunet.emqx.service.MqttRestClientService;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MqttHookService {
    private static final Logger log = LoggerFactory.getLogger(MqttHookService.class);
    @Autowired
    private CloudMgtDeviceMapper cloudMgtDeviceMapper;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private ScheduledExecutorService scheduledExecutorService;
    private static final Cache<String, String> CLIENT_CACHE = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).initialCapacity(1000).maximumSize(20000L).build();
    public static final String ONLINE = "1";
    private static final String OFFLINE = "0";
    private static final String KICK_OUT = "kicked";
    @Autowired
    private MqttRestClientService mqttRestClientService;

    public void connectHook(ConnectionRequest connectionRequest) {
        String connClientId = connectionRequest.getClientid();
        if (connClientId.indexOf("|mode=1") <= 0) {
            return;
        }
        String userName = connectionRequest.getUsername();
        if (userName.contains("super")) {
            return;
        }
        String event = connectionRequest.getEvent();
        long time = 0L;
        String state = OFFLINE;
        if ("client.disconnected".equals(event)) {
            state = OFFLINE;
            time = Long.parseLong(connectionRequest.getDisconnected_at());
        } else if ("client.connected".equals(event)) {
            state = ONLINE;
            time = Long.parseLong(connectionRequest.getConnected_at());
        }
        ConnectLazyState.stageConnect((String)userName, (String)connectionRequest.getClientid(), (Long)time, (String)state, (String)connectionRequest.getReason());
    }

    public void lazyBatchUpdateConnectionStatus() {
        List connectionStateList = ConnectLazyState.copyConnectState();
        if (connectionStateList == null) {
            return;
        }
        ArrayList<ConnectionStatus> onlineConnectionList = new ArrayList<ConnectionStatus>();
        ArrayList<ConnectionStatus> offlineConnectionList = new ArrayList<ConnectionStatus>();
        for (ConnectState connectState : connectionStateList) {
            String mqttAclKey = "mqtt_acl:" + connectState.getUsername();
            ConnectionStatus connectionStatus = this.buildConnectionStatus(connectState.getUsername(), connectState.getConnId(), connectState.getState());
            String sn = connectionStatus.getSn();
            if (OFFLINE.equals(connectionStatus.getOnline())) {
                if (KICK_OUT.equals(connectState.getReason()) && connectionStatus.getClientId().equals(CLIENT_CACHE.getIfPresent((Object)sn))) {
                    CLIENT_CACHE.invalidate((Object)sn);
                    continue;
                }
                offlineConnectionList.add(connectionStatus);
                this.redisTemplate.expire((Object)mqttAclKey, 10L, TimeUnit.MINUTES);
                if (offlineConnectionList.size() <= 300) continue;
                this.cloudMgtDeviceMapper.updateConnectOfflineStatus(offlineConnectionList);
                offlineConnectionList.clear();
                continue;
            }
            if (!ONLINE.equals(connectionStatus.getOnline())) continue;
            onlineConnectionList.add(connectionStatus);
            CLIENT_CACHE.put((Object)connectionStatus.getSn(), (Object)connectionStatus.getClientId());
            this.redisTemplate.persist((Object)mqttAclKey);
            if (onlineConnectionList.size() <= 300) continue;
            this.cloudMgtDeviceMapper.updateConnectOnlineStatus(onlineConnectionList);
            onlineConnectionList.clear();
        }
        if (!CollectionUtils.isEmpty(onlineConnectionList)) {
            this.cloudMgtDeviceMapper.updateConnectOnlineStatus(onlineConnectionList);
        }
        if (!CollectionUtils.isEmpty(offlineConnectionList)) {
            this.cloudMgtDeviceMapper.updateConnectOfflineStatus(offlineConnectionList);
        }
    }

    private ConnectionStatus buildConnectionStatus(String userName, String connId, String state) {
        String[] usernamePair = userName.split("\\.");
        String sn = usernamePair[0];
        String product = usernamePair[1];
        ConnectionStatus connectionStatus = new ConnectionStatus();
        connectionStatus.setSn(sn);
        connectionStatus.setProduct(product);
        String clientId = connId.split("\\|")[0];
        String mac = clientId.split("\\.")[1];
        connectionStatus.setMac(mac);
        connectionStatus.setClientId(connId);
        connectionStatus.setOnline(state);
        return connectionStatus;
    }

    private void checkConnectionStatus() {
        List checkConnectList = ConnectLazyState.copyCheckConnect();
        if (checkConnectList == null) {
            return;
        }
        Iterator iterator = checkConnectList.iterator();
        while (iterator.hasNext()) {
            ConnectCheck connectCheck;
            boolean status = this.mqttRestClientService.checkClientStatus((connectCheck = (ConnectCheck)iterator.next()).getClientid());
            ConnectLazyState.checkConnect2State((ConnectCheck)connectCheck, (String)(status ? ONLINE : OFFLINE));
            ConnectLazyState.removeConnectCheck((String)connectCheck.getUsername());
        }
    }

    @PostConstruct
    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                this.lazyBatchUpdateConnectionStatus();
            }
            catch (Exception e) {
                log.error("write connection status error", (Throwable)e);
            }
        }, 200L, 100L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                this.checkConnectionStatus();
            }
            catch (Exception e) {
                log.error("check connection status error", (Throwable)e);
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }
}

