/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.emqx.service;

import com.alibaba.fastjson2.JSON;
import com.hohunet.common.utils.SignUtils;
import com.hohunet.emqx.domain.CloudMgtDevice;
import com.hohunet.emqx.domain.MqttAuthorResult;
import com.hohunet.emqx.mapper.CloudMgtDeviceMapper;
import com.hohunet.emqx.service.AbstractModelService;
import com.hohunet.emqx.service.CloudMgtDeviceService;
import com.hohunet.mqtt.domain.MqttAuthor;
import jakarta.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MqttExchangeModeService
extends AbstractModelService {
    private static Logger logger = LoggerFactory.getLogger(MqttExchangeModeService.class);
    public static final String SUPER_MODE = "3";
    public static final String EXCHANGE_MODE = "2";
    public static final String STAND_MODE = "1";
    private static String CA_PEM_STR;
    private static final List<MqttAuthorResult.Acl> EXCHANGE_ACL_TEMPLATE;
    @Autowired
    private CloudMgtDeviceService cloudMgtDeviceService;
    @Autowired
    private CloudMgtDeviceMapper cloudMgtDeviceMapper;

    public MqttAuthorResult exchangeModeAuth(String sn, String product, String mac, String cid, String nid, String method, String signContent, MqttAuthor mqttAuthor) {
        this.readCaKey();
        String sign = SignUtils.encrypt((String)signContent, (String)CA_PEM_STR, (String)method);
        if (sign.equals(mqttAuthor.getPassword())) {
            CloudMgtDevice cloudMgtDevice;
            MqttAuthorResult authorResult = this.grantExchangeAcl(product, sn);
            try {
                cloudMgtDevice = this.cloudMgtDeviceService.cloudMgtDeviceRegister(sn, mac.toUpperCase(), cid, nid, product, mqttAuthor.getHost());
            }
            catch (Exception e) {
                logger.error("device register failed!!", (Throwable)e);
                return this.denyResult();
            }
            try {
                if (!this.cloudMgtDeviceService.lazyPublishSnSecret(cloudMgtDevice)) {
                    return this.denyResult();
                }
            }
            catch (Exception e) {
                logger.error("pub sn reg-msg failed!!", (Throwable)e);
                return this.denyResult();
            }
            return authorResult;
        }
        return this.denyResult();
    }

    private MqttAuthorResult grantExchangeAcl(String product, String sn) {
        MqttAuthorResult authorResult = this.allowResult(false);
        authorResult.setExpireAt(Long.valueOf(System.currentTimeMillis() / 1000L + 60L));
        authorResult.setAcl(this.grantExchangeACL(product, sn));
        return authorResult;
    }

    private List<MqttAuthorResult.Acl> grantExchangeACL(String product, String sn) {
        ArrayList<MqttAuthorResult.Acl> acls = new ArrayList<MqttAuthorResult.Acl>(8);
        if (EXCHANGE_ACL_TEMPLATE.isEmpty()) {
            this.initExchangeAclTemplate();
        }
        for (MqttAuthorResult.Acl aclTemplate : EXCHANGE_ACL_TEMPLATE) {
            acls.add(aclTemplate.clone(product, sn));
        }
        return acls;
    }

    private synchronized void initExchangeAclTemplate() {
        if (!EXCHANGE_ACL_TEMPLATE.isEmpty()) {
            return;
        }
        InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("acl/exchange.acl");
        if (inStream != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));){
                String aclDefine;
                while ((aclDefine = reader.readLine()) != null) {
                    aclDefine = this.charEmpty(aclDefine);
                    String[] aclProps = aclDefine.split("=");
                    EXCHANGE_ACL_TEMPLATE.add(this.buildAcl(aclProps[0], aclProps[1]));
                }
                inStream.close();
            }
            catch (IOException e) {
                logger.error("loader exchange_acl file error", (Throwable)e);
            }
        }
    }

    private MqttAuthorResult.Acl buildAcl(String topic, String json) {
        MqttAuthorResult.Acl acl = (MqttAuthorResult.Acl)JSON.parseObject((String)json, MqttAuthorResult.Acl.class);
        acl.setTopic(topic);
        return acl;
    }

    private void readCaKey() {
        if (CA_PEM_STR == null) {
            StringBuilder ca = new StringBuilder();
            InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("cert/mqtt/dahu_ca.pem");
            if (inStream != null) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.contains("CERTIFICATE")) continue;
                        ca.append(line);
                    }
                    inStream.close();
                }
                catch (IOException e) {
                    logger.error("loader ca file error", (Throwable)e);
                }
                CA_PEM_STR = ca.toString();
            }
        }
    }

    private void warmLoadDeviceCache() {
        List cloudMgtDevices = this.cloudMgtDeviceMapper.selectAllCloudDeviceCache();
        for (CloudMgtDevice cloudMgtDevice : cloudMgtDevices) {
            this.cloudMgtDeviceService.storeDeviceCache(cloudMgtDevice);
        }
    }

    @PostConstruct
    public void init() {
        this.readCaKey();
        this.initExchangeAclTemplate();
        this.warmLoadDeviceCache();
    }

    static {
        EXCHANGE_ACL_TEMPLATE = new ArrayList();
    }
}

