/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.emqx.service;

import com.hohunet.common.utils.SignUtils;
import com.hohunet.common.utils.StringUtils;
import com.hohunet.emqx.domain.MqttAuthorResult;
import com.hohunet.emqx.service.MqttExchangeModeService;
import com.hohunet.emqx.service.MqttStandModelService;
import com.hohunet.mqtt.config.MqttConfigBean;
import com.hohunet.mqtt.domain.MqttAuthor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MqttAuthorService {
    private static final String SUPER_NAME = "super";
    private static final Logger log = LoggerFactory.getLogger(MqttAuthorService.class);
    @Autowired
    private MqttConfigBean mqttConfig;
    @Autowired
    private MqttExchangeModeService mqttExchangeModeService;
    @Autowired
    private MqttStandModelService mqttStandModelService;
    private List<String> signAlg = Arrays.asList("hmacmd5", "hmacsha1", "hmacsha256");

    public MqttAuthorResult authCheck(MqttAuthor mqttAuthor) {
        String mqttClientId = mqttAuthor.getClientId();
        String[] clientPair = mqttClientId.split("\\|");
        if (clientPair.length < 2) {
            return this.mqttExchangeModeService.denyResult();
        }
        String clientId = clientPair[0];
        String conAttrs = clientPair[1];
        Map conAttrMap = MqttAuthorService.parseString((String)conAttrs);
        if (conAttrMap.size() != 3) {
            return this.mqttExchangeModeService.denyResult();
        }
        String mode = (String)conAttrMap.get("mode");
        String method = (String)conAttrMap.get("method");
        String timestamp = (String)conAttrMap.get("timestamp");
        if (mode == null || method == null || timestamp == null) {
            return this.mqttExchangeModeService.denyResult();
        }
        if (!this.signAlg.contains(method.toLowerCase())) {
            return this.mqttExchangeModeService.denyResult();
        }
        String username = mqttAuthor.getUsername();
        if (username == null) {
            return this.mqttExchangeModeService.denyResult();
        }
        String[] userPair = username.split("\\.");
        if (userPair.length != 2) {
            return this.mqttExchangeModeService.denyResult();
        }
        String product = userPair[1];
        String[] clientIdPair = clientId.split("\\.");
        if (clientIdPair.length != 2) {
            return this.mqttExchangeModeService.denyResult();
        }
        String clientSn = clientIdPair[0];
        String clientMac = clientIdPair[1];
        if (StringUtils.isEmpty((String)clientSn) || StringUtils.isEmpty((String)clientMac)) {
            return this.mqttExchangeModeService.denyResult();
        }
        String connectId = "sn" + clientSn + "mac" + clientMac;
        String signContent = "connectId" + connectId + "timestamp" + timestamp;
        if ("super".equals(clientSn) && "3".equals(mode)) {
            String sign = SignUtils.encrypt((String)signContent, (String)this.mqttConfig.getSuperSecret(), (String)method);
            if (sign.equals(mqttAuthor.getPassword())) {
                return this.mqttExchangeModeService.allowResult(true);
            }
        } else {
            if ("2".equals(mode)) {
                String cid = null;
                String nid = null;
                if (clientPair.length == 3) {
                    String paramAttrs = clientPair[2];
                    Map paramAttrMap = MqttAuthorService.parseString((String)paramAttrs);
                    cid = (String)paramAttrMap.get("cid");
                    nid = (String)paramAttrMap.get("nid");
                    if (!StringUtils.isEmpty((String)nid) && StringUtils.isEmpty((String)cid)) {
                        log.warn("ztp must have a CID. sn:{}, ztp-param: {}", (Object)clientSn, (Object)paramAttrs);
                        return this.mqttExchangeModeService.denyResult();
                    }
                }
                return this.mqttExchangeModeService.exchangeModeAuth(clientSn, product, clientMac, cid, nid, method, signContent, mqttAuthor);
            }
            if ("1".equals(mode)) {
                return this.mqttStandModelService.domainModeAuth(username, clientSn, product, clientMac, method, signContent, mqttAuthor.getPassword(), mqttAuthor.getClientId());
            }
        }
        return this.mqttExchangeModeService.denyResult();
    }

    public static Map<String, String> parseString(String eqValStr) {
        String[] pairs;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (eqValStr == null || eqValStr.isEmpty()) {
            return resultMap;
        }
        for (String pair : pairs = eqValStr.split(",")) {
            String[] keyValue = pair.split("=", 2);
            if (keyValue.length != 2) continue;
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            resultMap.put(key, value);
        }
        return resultMap;
    }
}

