/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.emqx.service;

import com.hohunet.common.utils.RandomUtils;
import com.hohunet.emqx.mapper.CloudMgtDeviceMapper;
import jakarta.annotation.PostConstruct;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MatchCodeService {
    @Autowired
    private ScheduledExecutorService scheduledExecutorService;
    @Autowired
    private CloudMgtDeviceMapper cloudMgtDeviceMapper;
    private static final Queue<String> MATCH_CODE_CACHE = new ConcurrentLinkedQueue();

    public String genMatchCode() {
        if (MATCH_CODE_CACHE.isEmpty()) {
            this.matchCodeFactory();
        }
        return (String)MATCH_CODE_CACHE.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void matchCodeFactory() {
        Queue queue = MATCH_CODE_CACHE;
        synchronized (queue) {
            while (MATCH_CODE_CACHE.size() < 500) {
                Set batchCodes = this.batchMatchCode();
                batchCodes.removeAll(MATCH_CODE_CACHE);
                List uniqueCodes = this.cloudMgtDeviceMapper.checkMatchCodeUnique(batchCodes);
                for (String code : uniqueCodes) {
                    MATCH_CODE_CACHE.offer(code);
                }
                if (!batchCodes.isEmpty()) continue;
                break;
            }
        }
    }

    private Set<String> batchMatchCode() {
        HashSet<String> candidates = new HashSet<String>();
        while (candidates.size() < 200) {
            candidates.add(RandomUtils.genRandomStr((int)5));
        }
        return candidates;
    }

    @PostConstruct
    public void init() {
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> this.matchCodeFactory(), 1L, 10L, TimeUnit.SECONDS);
    }
}

