/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.emqx.service;

import com.hohunet.buffer.LoadCityBuffer;
import com.hohunet.buffer.NwkCloudDeviceBuffer;
import com.hohunet.buffer.RegisterCloudDeviceBuffer;
import com.hohunet.cache.DeviceLocalCache;
import com.hohunet.cache.RegisterWillCache;
import com.hohunet.cache.domain.DeviceCache;
import com.hohunet.common.exception.ServiceException;
import com.hohunet.common.product.ProductLicense;
import com.hohunet.common.utils.RandomUtils;
import com.hohunet.common.utils.StringUtils;
import com.hohunet.disrupt.event.CloudDeviceEvent;
import com.hohunet.disrupt.publish.NonBlockingEventPublisher;
import com.hohunet.emqx.domain.CloudMgtDevice;
import com.hohunet.emqx.domain.SnConnectInfo;
import com.hohunet.emqx.listener.SnBindStatusListener;
import com.hohunet.emqx.mapper.CloudMgtDeviceMapper;
import com.hohunet.emqx.service.MatchCodeService;
import com.hohunet.ip.service.IpLocationService;
import com.hohunet.mqtt.payload.MqttResponse;
import com.hohunet.mqtt.publish.MqttInvokeFactory;
import jakarta.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CloudMgtDeviceService {
    private static final Logger log = LoggerFactory.getLogger(CloudMgtDeviceService.class);
    @Autowired
    private CloudMgtDeviceMapper cloudMgtDeviceMapper;
    @Autowired
    private IpLocationService ipLocationService;
    @Autowired
    private MatchCodeService matchCodeService;
    @Autowired
    private RegisterCloudDeviceBuffer registerCloudDeviceBuffer;
    @Autowired
    private NwkCloudDeviceBuffer nwkCloudDeviceBuffer;
    @Resource(name="mqttReplyEventPublisher")
    private NonBlockingEventPublisher<CloudDeviceEvent> mqttReplyEventPublisher;
    @Autowired
    private SnBindStatusListener snBindStatusListener;
    public static final String UNBIND_STATUS = "1";
    public static final String BIND_STATUS = "2";
    public static final String ACTION_UNBIND = "0";
    public static final String ACTION_BIND = "1";
    public static final String ACTION_IGNORE = "3";
    @Autowired
    private LoadCityBuffer loadCityBuffer;

    public boolean lazyPublishSnSecret(CloudMgtDevice cloudMgtDevice) {
        boolean status;
        Boolean state = RegisterWillCache.getWillState((String)cloudMgtDevice.getSn());
        if (state != null) {
            MqttInvokeFactory.factory((String)"register").sn(cloudMgtDevice.getSn(), cloudMgtDevice.getType()).willClean();
            RegisterWillCache.removeWillState((String)cloudMgtDevice.getSn());
        }
        if (!(status = this.mqttReplyEventPublisher.tryPublish((event, sequence) -> {
            event.setEvent("pub_domain");
            event.setData(cloudMgtDevice);
        }))) {
            log.error("pub register msg fail, ring buff full!! sn:{}", (Object)cloudMgtDevice.getSn());
        }
        return status;
    }

    @Transactional(rollbackFor={Throwable.class})
    public CloudMgtDevice cloudMgtDeviceRegister(String sn, String mac, String cid, String nid, String product, String host) throws IllegalAccessException {
        CloudMgtDevice cloudMgtDevice;
        DeviceCache deviceCache = DeviceLocalCache.getCloudDevice((String)sn);
        if (deviceCache != null) {
            boolean offUnbind = this.snBindStatusListener.refreshDeviceCodeAndSecret(sn);
            cloudMgtDevice = new CloudMgtDevice();
            cloudMgtDevice.setId(deviceCache.getId());
            cloudMgtDevice.setType(product);
            cloudMgtDevice.setSn(sn);
            cloudMgtDevice.setMac(deviceCache.getMac());
            cloudMgtDevice.setMatchCode(deviceCache.getMatchCode());
            cloudMgtDevice.setSecret(deviceCache.getSecret());
            cloudMgtDevice.setWanIp(deviceCache.getWanIp());
            this.deviceBindAction(deviceCache, cloudMgtDevice, cid, nid, offUnbind);
            if (cloudMgtDevice.getStatus() != null) {
                deviceCache.setStatus(cloudMgtDevice.getStatus());
            }
            if (cloudMgtDevice.getOrgId() != null) {
                deviceCache.setCid(cloudMgtDevice.getOrgId());
            }
            if (cloudMgtDevice.getNetworkId() != null) {
                deviceCache.setLastNid(cloudMgtDevice.getNetworkId());
            }
        } else {
            if (DeviceLocalCache.registerDevNum() > ProductLicense.authDevNum()) {
                log.error("sn {} register failed!! lic limit total {}!!", (Object)sn, (Object)ProductLicense.authDevNum());
                throw new IllegalAccessException();
            }
            cloudMgtDevice = this.createCloudMgtDevice(sn, mac, cid, nid, product, host);
            this.storeDeviceCache(cloudMgtDevice);
        }
        if (!host.equals(cloudMgtDevice.getWanIp())) {
            cloudMgtDevice.setWanIp(host);
            if (deviceCache != null) {
                deviceCache.setWanIp(host);
            }
            this.loadCityBuffer.add(cloudMgtDevice);
        }
        return cloudMgtDevice;
    }

    public void storeDeviceCache(CloudMgtDevice cloudMgtDevice) {
        DeviceCache deviceCache = new DeviceCache();
        deviceCache.setId(cloudMgtDevice.getId());
        deviceCache.setMac(cloudMgtDevice.getMac());
        deviceCache.setStatus(cloudMgtDevice.getStatus());
        deviceCache.setMatchCode(cloudMgtDevice.getMatchCode());
        deviceCache.setSecret(cloudMgtDevice.getSecret());
        deviceCache.setWanIp(cloudMgtDevice.getWanIp());
        deviceCache.setLastNid(cloudMgtDevice.getNetworkId());
        deviceCache.setCid(cloudMgtDevice.getOrgId());
        DeviceLocalCache.setCloudDevice((String)cloudMgtDevice.getSn(), (DeviceCache)deviceCache);
    }

    private void deviceBindAction(DeviceCache deviceCache, CloudMgtDevice cloudMgtDevice, String cid, String nid, boolean offUnbind) {
        if (BIND_STATUS.equals(deviceCache.getStatus())) {
            if (!StringUtils.isEmpty((String)nid) && !nid.equals(deviceCache.getLastNid())) {
                cloudMgtDevice.setOrgId(cid);
                cloudMgtDevice.setNetworkId(nid);
                MqttResponse resp = MqttInvokeFactory.factory((String)"change-bind", (Object[])new String[]{cloudMgtDevice.getSn()}).future(5);
                if (!resp.isOk()) {
                    log.error("bind change bind nid fail, sn:{}", (Object)cloudMgtDevice.getSn());
                }
                cloudMgtDevice.setAction("1");
                cloudMgtDevice.setStatus(BIND_STATUS);
                this.cloudMgtDeviceMapper.updateCloudDeviceNwk(cloudMgtDevice);
            } else {
                cloudMgtDevice.setAction(ACTION_IGNORE);
            }
        } else if ("1".equals(deviceCache.getStatus())) {
            if (!StringUtils.isEmpty((String)nid) && !nid.equals(deviceCache.getLastNid())) {
                cloudMgtDevice.setOrgId(cid);
                cloudMgtDevice.setNetworkId(nid);
                MqttResponse resp = MqttInvokeFactory.factory((String)"auth-bind", (Object[])new String[]{cloudMgtDevice.getSn()}).future(2);
                if (resp.isOk()) {
                    cloudMgtDevice.setAction("1");
                    cloudMgtDevice.setStatus(BIND_STATUS);
                    this.cloudMgtDeviceMapper.insertCloudDeviceNwk(cloudMgtDevice);
                } else {
                    log.error("unbind change to bind nid fail, sn:{}", (Object)cloudMgtDevice.getSn());
                    cloudMgtDevice.setAction(ACTION_UNBIND);
                    cloudMgtDevice.setStatus("1");
                }
            } else {
                if (!(offUnbind || StringUtils.isEmpty((String)cid) || cid.equals(deviceCache.getCid()))) {
                    cloudMgtDevice.setOrgId(cid);
                    this.cloudMgtDeviceMapper.updateCloudDeviceCid(cloudMgtDevice);
                }
                if (offUnbind) {
                    cloudMgtDevice.setAction(ACTION_UNBIND);
                } else {
                    cloudMgtDevice.setAction(ACTION_IGNORE);
                }
            }
        }
    }

    private CloudMgtDevice createCloudMgtDevice(String sn, String mac, String cid, String nid, String product, String wanIp) {
        CloudMgtDevice cloudMgtDevice = new CloudMgtDevice();
        cloudMgtDevice.setSn(sn);
        cloudMgtDevice.setMac(mac);
        cloudMgtDevice.setWanIp(wanIp);
        cloudMgtDevice.setOrgId(cid);
        cloudMgtDevice.setNetworkId(nid);
        cloudMgtDevice.setCity(this.ipLocationService.geoLocation(wanIp));
        cloudMgtDevice.setMatchCode(this.matchCodeService.genMatchCode());
        cloudMgtDevice.setSecret(RandomUtils.simpleUUID());
        cloudMgtDevice.setType(product);
        if (!StringUtils.isEmpty((String)nid)) {
            cloudMgtDevice.setStatus(BIND_STATUS);
            cloudMgtDevice.setAction("1");
        } else {
            cloudMgtDevice.setStatus("1");
            cloudMgtDevice.setAction(ACTION_UNBIND);
        }
        cloudMgtDevice.setId(RandomUtils.simpleUUID());
        boolean waiteStatus = this.registerCloudDeviceBuffer.addCloudMgtDevice(cloudMgtDevice);
        if (!waiteStatus) {
            throw new ServiceException("create cloud device batch waite fail, sn:" + sn);
        }
        return cloudMgtDevice;
    }

    public SnConnectInfo findCloudMgtDeviceConnectInfo(String sn, String mac) {
        return this.cloudMgtDeviceMapper.selectCloudMgtDeviceConnectInfo(sn, mac);
    }
}

