/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.emqx.listener;

import com.alibaba.fastjson2.TypeReference;
import com.hohunet.cache.DeviceLocalCache;
import com.hohunet.cache.domain.DeviceCache;
import com.hohunet.common.core.redis.RedisCache;
import com.hohunet.common.utils.RandomUtils;
import com.hohunet.emqx.domain.CloudMgtDevice;
import com.hohunet.emqx.domain.SnBind;
import com.hohunet.emqx.listener.AbstractMqttSub;
import com.hohunet.emqx.mapper.CloudMgtDeviceMapper;
import com.hohunet.emqx.service.MatchCodeService;
import com.hohunet.mqtt.payload.MqttRequest;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class SnBindStatusListener
extends AbstractMqttSub<MqttRequest<SnBind>> {
    public static final String SYNC_DEVICE_UNBIND = "sync-unbind";
    public static final String WAIT_RESET_KEY = "wait:reset";
    public static final Map<String, String> WAIT_RESET_DEVICE = new ConcurrentHashMap();
    public static final String OFFLINE_UNBIND = "1";
    @Autowired
    private CloudMgtDeviceMapper cloudMgtDeviceMapper;
    @Autowired
    private MatchCodeService matchCodeService;
    @Autowired
    private RedisCache redisCache;

    public String topic() {
        return "dhcs/device/bind/status";
    }

    public Object messageArrived(String topic, MqttRequest<SnBind> payload) {
        SnBind snBind = (SnBind)payload.getData();
        String sn = snBind.getSn();
        DeviceCache deviceCache = DeviceLocalCache.getCloudDevice((String)sn);
        if (SYNC_DEVICE_UNBIND.equals(payload.getMethod())) {
            deviceCache.setStatus(OFFLINE_UNBIND);
            deviceCache.setCid(null);
            WAIT_RESET_DEVICE.put(sn, snBind.getOffUnbind() == null ? "" : OFFLINE_UNBIND);
            return this.response(payload.getId(), Collections.singletonMap("matchCode", deviceCache.getMatchCode()));
        }
        deviceCache.setCid(snBind.getOrgId());
        deviceCache.setLastNid(snBind.getNetworkId());
        deviceCache.setStatus("2");
        WAIT_RESET_DEVICE.remove(sn);
        return payload;
    }

    public boolean refreshDeviceCodeAndSecret(String sn) {
        String unbindType = (String)WAIT_RESET_DEVICE.get(sn);
        if (unbindType != null) {
            DeviceCache deviceCache = DeviceLocalCache.getCloudDevice((String)sn);
            CloudMgtDevice cloudMgtDevice = new CloudMgtDevice();
            cloudMgtDevice.setId(deviceCache.getId());
            cloudMgtDevice.setMatchCode(this.matchCodeService.genMatchCode());
            cloudMgtDevice.setSecret(RandomUtils.simpleUUID());
            deviceCache.setMatchCode(cloudMgtDevice.getMatchCode());
            deviceCache.setSecret(cloudMgtDevice.getSecret());
            this.cloudMgtDeviceMapper.updateCloudMgtDeviceSecret(cloudMgtDevice);
            WAIT_RESET_DEVICE.remove(sn);
            return OFFLINE_UNBIND.equals(unbindType);
        }
        return false;
    }

    public TypeReference<MqttRequest<SnBind>> serializer() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public int qos() {
        return 1;
    }

    @PostConstruct
    public void init() {
        Map recoverDevice = this.redisCache.getCacheMap(WAIT_RESET_KEY);
        WAIT_RESET_DEVICE.putAll(recoverDevice);
        this.redisCache.deleteObject(WAIT_RESET_KEY);
    }

    @EventListener(value={ContextClosedEvent.class})
    public void stop() {
        this.redisCache.setCacheMap(WAIT_RESET_KEY, WAIT_RESET_DEVICE);
    }
}

