/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.disrupt.publish;

import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.RingBuffer;

public class NonBlockingEventPublisher<T> {
    private final RingBuffer<T> ringBuffer;

    public NonBlockingEventPublisher(RingBuffer<T> ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean tryPublish(EventTranslator<T> translator) {
        if (this.ringBuffer == null) {
            return false;
        }
        try {
            long sequence = this.ringBuffer.tryNext(1);
            try {
                translator.translateTo(this.ringBuffer.get(sequence), sequence);
            }
            finally {
                this.ringBuffer.publish(sequence);
            }
            return true;
        }
        catch (InsufficientCapacityException e) {
            return false;
        }
    }
}

