/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.disrupt.handler;

import com.hohunet.cache.RegisterWillCache;
import com.hohunet.disrupt.event.CloudDeviceEvent;
import com.hohunet.emqx.domain.CloudMgtDevice;
import com.hohunet.mqtt.publish.MqttInvokeFactory;
import com.lmax.disruptor.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DisruptEventHandler
implements EventHandler<CloudDeviceEvent> {
    private static final Logger log = LoggerFactory.getLogger(DisruptEventHandler.class);

    public void onEvent(CloudDeviceEvent event, long l, boolean b) {
        try {
            if ("pub_domain".equals(event.getEvent())) {
                this.publishDomain(event.getData());
            }
        }
        catch (Exception e) {
            log.error("publish event handler error, event={}", (Object)event.getEvent(), (Object)e);
        }
    }

    private void publishDomain(CloudMgtDevice cloudMgtDevice) {
        MqttInvokeFactory.factory((String)"register", (Object[])new CloudMgtDevice[]{cloudMgtDevice}).sn(cloudMgtDevice.getSn(), cloudMgtDevice.getType()).retain(true).expiry(30L).invoke();
        RegisterWillCache.setWillState((String)cloudMgtDevice.getSn(), (Boolean)true);
    }
}

