/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.buffer;

import com.hohunet.buffer.NwkCloudDeviceBuffer;
import com.hohunet.common.exception.ServiceException;
import com.hohunet.common.utils.StringUtils;
import com.hohunet.emqx.domain.CloudMgtDevice;
import com.hohunet.emqx.mapper.CloudMgtDeviceMapper;
import com.hohunet.mqtt.payload.MqttResponse;
import com.hohunet.mqtt.publish.MqttInvokeFactory;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class RegisterCloudDeviceBuffer {
    private static final Logger logger = LoggerFactory.getLogger(RegisterCloudDeviceBuffer.class);
    @Autowired
    private ScheduledExecutorService scheduledExecutorService;
    @Autowired
    private CloudMgtDeviceMapper cloudMgtDeviceMapper;
    @Autowired
    private NwkCloudDeviceBuffer nwkCloudDeviceBuffer;
    @Autowired
    @Lazy
    private RegisterCloudDeviceBuffer registerCloudDeviceBuffer;
    private static final Lock writeLock = new ReentrantLock();
    private static final Condition writeCondition = writeLock.newCondition();
    private static boolean syncDeviceStatus = false;
    private final List<CloudMgtDevice> cloudMgtDevices = new ArrayList(1000);

    public boolean addCloudMgtDevice(CloudMgtDevice cloudMgtDevice) {
        writeLock.lock();
        try {
            this.cloudMgtDevices.add(cloudMgtDevice);
            if (!StringUtils.isEmpty((String)cloudMgtDevice.getNetworkId())) {
                this.nwkCloudDeviceBuffer.add(cloudMgtDevice);
            }
            if (this.cloudMgtDevices.size() > 200) {
                this.flush();
            }
            if (!writeCondition.await(5L, TimeUnit.SECONDS)) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            logger.error("sync device wait interrupted", (Throwable)e);
        }
        finally {
            writeLock.unlock();
        }
        return syncDeviceStatus;
    }

    @Transactional(rollbackFor={Exception.class})
    public void registerSyncCloudDevice() {
        ArrayList insertCloudMgtDevices = new ArrayList(this.cloudMgtDevices);
        this.cloudMgtDeviceMapper.insertBatchCloudMgtDevice(insertCloudMgtDevices);
        MqttResponse resp = MqttInvokeFactory.factory((String)"notify", (Object[])new List[]{insertCloudMgtDevices}).future(3);
        syncDeviceStatus = resp.isOk();
        this.cloudMgtDevices.clear();
        if (!syncDeviceStatus) {
            throw new ServiceException("sync device fail, please check dhcs-service.");
        }
    }

    @PreDestroy
    public void flush() {
        if (!this.cloudMgtDevices.isEmpty()) {
            writeLock.lock();
            try {
                this.registerCloudDeviceBuffer.registerSyncCloudDevice();
                writeCondition.signalAll();
            }
            catch (Exception e) {
                logger.error("sync device flush error");
            }
            finally {
                writeLock.unlock();
            }
        }
        this.nwkCloudDeviceBuffer.flush();
    }

    @PostConstruct
    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(() -> this.flush(), 200L, 100L, TimeUnit.MILLISECONDS);
    }
}

