/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.buffer;

import com.hohunet.emqx.domain.CloudMgtDevice;
import com.hohunet.emqx.mapper.CloudMgtDeviceMapper;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NwkCloudDeviceBuffer {
    private static final Logger logger = LoggerFactory.getLogger(NwkCloudDeviceBuffer.class);
    @Autowired
    private CloudMgtDeviceMapper cloudMgtDeviceMapper;
    private final BlockingQueue<CloudMgtDevice> cloudMgtDeviceBuffer = new ArrayBlockingQueue(1000);

    public void add(CloudMgtDevice cloudMgtDevice) {
        if (!this.cloudMgtDeviceBuffer.offer(cloudMgtDevice)) {
            logger.warn("load nwk bind queue full");
        }
        if (this.cloudMgtDeviceBuffer.size() > 200) {
            this.flush();
        }
    }

    public void flush() {
        if (!this.cloudMgtDeviceBuffer.isEmpty()) {
            ArrayList cloudMgtDeviceList = new ArrayList();
            this.cloudMgtDeviceBuffer.drainTo(cloudMgtDeviceList);
            try {
                this.cloudMgtDeviceMapper.insertBatchCloudDeviceNwk(cloudMgtDeviceList);
                this.cloudMgtDeviceMapper.updateCloudDeviceBindStatus(cloudMgtDeviceList);
            }
            catch (Exception e) {
                logger.error("nwk flush fail", (Throwable)e);
            }
        }
    }
}

