/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.buffer;

import com.hohunet.emqx.domain.CloudMgtDevice;
import com.hohunet.emqx.mapper.CloudMgtDeviceMapper;
import com.hohunet.ip.service.IpLocationService;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoadCityBuffer
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(LoadCityBuffer.class);
    @Autowired
    private CloudMgtDeviceMapper cloudMgtDeviceMapper;
    @Autowired
    private IpLocationService ipLocationService;
    @Autowired
    private ScheduledExecutorService scheduledExecutorService;
    private final BlockingQueue<CloudMgtDevice> cloudMgtDeviceBuffer = new ArrayBlockingQueue(5000);

    public void add(CloudMgtDevice cloudMgtDevice) {
        if (!this.cloudMgtDeviceBuffer.offer(cloudMgtDevice)) {
            logger.warn("load city buff queue full");
        }
        if (this.cloudMgtDeviceBuffer.size() > 200) {
            this.flush();
        }
    }

    @PreDestroy
    public void flush() {
        if (!this.cloudMgtDeviceBuffer.isEmpty()) {
            ArrayList cloudMgtDeviceList = new ArrayList();
            this.cloudMgtDeviceBuffer.drainTo(cloudMgtDeviceList);
            for (CloudMgtDevice cloudMgtDevice : cloudMgtDeviceList) {
                cloudMgtDevice.setCity(this.ipLocationService.geoLocation(cloudMgtDevice.getWanIp()));
            }
            this.cloudMgtDeviceMapper.updateIpLocationOfCity(cloudMgtDeviceList);
        }
    }

    public void afterPropertiesSet() {
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> this.flush(), 10L, 3L, TimeUnit.SECONDS);
    }
}

