/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.web.core.config;

import com.hohunet.web.core.config.OpenApiProperties;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={OpenAPI.class})
@EnableConfigurationProperties(value={OpenApiProperties.class})
@ConditionalOnProperty(prefix="springdoc.api-docs", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class OpenApiConfig {
    @Bean
    public OpenAPI springOpenApi(OpenApiProperties properties) {
        return new OpenAPI().info(this.buildInfo(properties));
    }

    private Info buildInfo(OpenApiProperties properties) {
        return new Info().title(properties.getTitle()).description(properties.getDescription()).version(properties.getVersion()).contact(new Contact().name(properties.getAuthor()).url(properties.getUrl()).email(properties.getEmail())).license(new License().name(properties.getLicense()).url(properties.getLicenseUrl()));
    }
}

