/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.dhcs.service;

import com.hohunet.common.core.domain.AjaxResult;
import com.hohunet.common.core.domain.entity.SysUser;
import com.hohunet.common.core.domain.model.LoginBody;
import com.hohunet.common.core.domain.model.LoginUser;
import com.hohunet.common.core.redis.RedisCache;
import com.hohunet.common.exception.ServiceException;
import com.hohunet.common.service.TokenService;
import com.hohunet.common.utils.SecurityUtils;
import com.hohunet.dhcs.domain.LoginQr;
import com.hohunet.dhcs.domain.SceneCode;
import com.hohunet.dhcs.service.WxMpApiService;
import com.hohunet.framework.web.domain.Login;
import com.hohunet.framework.web.service.SysLoginService;
import com.hohunet.system.service.ISysUserService;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxMpService {
    @Autowired
    private ISysUserService userService;
    @Autowired
    private SysLoginService loginService;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private WxMpApiService wxMpApiService;

    public AjaxResult scanLoginStatus(String sceneStr) {
        SceneCode sceneCode = this.wxMpApiService.parseScene(sceneStr);
        String sceneId = sceneCode.getSceneId();
        Map scanSign = this.checkQrStatus(sceneId);
        String status = (String)scanSign.get("status");
        if ("4".equals(status)) {
            return AjaxResult.error((int)201, (String)"common.qrcode.unscan");
        }
        if ("3".equals(status)) {
            return AjaxResult.error((int)302, (String)"common.qrcode.unbind");
        }
        if ("2".equals(status)) {
            String openid = (String)scanSign.get("openid");
            return this.wxMpLogin(openid, sceneId);
        }
        return AjaxResult.error((int)202, (String)"common.qrcode.unauth");
    }

    private Map<String, String> checkQrStatus(String sceneId) {
        Map scanSign = (Map)this.redisCache.getCacheObject("wx:mp:scan:" + sceneId);
        if (scanSign == null) {
            throw new ServiceException("common.qrcode.expire", Integer.valueOf(508));
        }
        String status = (String)scanSign.get("status");
        if ("5".equals(status)) {
            throw new ServiceException("common.qrcode.unknown", Integer.valueOf(509));
        }
        return scanSign;
    }

    public AjaxResult scanBindStatus(String sceneStr) {
        SceneCode sceneCode = this.wxMpApiService.parseScene(sceneStr);
        String sceneId = sceneCode.getSceneId();
        Map scanSign = this.checkQrStatus(sceneId);
        String status = (String)scanSign.get("status");
        String openid = (String)scanSign.get("openid");
        if ("4".equals(status)) {
            return AjaxResult.error((int)201, (String)"common.qrcode.unscan");
        }
        if ("3".equals(status)) {
            String code = (String)scanSign.get("code");
            String nickWx = this.wxMpApiService.reqWxUserInfo(code, openid);
            return this.bindLoginMpOpenId(sceneId, openid, nickWx);
        }
        if ("2".equals(status)) {
            SysUser user = this.userService.selectUserByOpenId(openid);
            if (!user.getUserName().equals(SecurityUtils.getUsername())) {
                return AjaxResult.error((int)501, (String)"common.wx.unique");
            }
            return AjaxResult.success((Object)user);
        }
        return AjaxResult.success();
    }

    private AjaxResult wxMpLogin(String openid, String sceneId) {
        SysUser user = this.userService.selectUserByOpenId(openid);
        if (user != null) {
            this.redisCache.deleteObject("wx:mp:scan:" + sceneId);
            Login login = new Login();
            login.setUsername(user.getUserName());
            login.setLoginType("wx");
            return this.loginService.login(user.getUserName(), login);
        }
        return AjaxResult.error((int)507, (String)"common.not.user");
    }

    public AjaxResult bindMpOpenId(LoginBody loginBody) {
        SceneCode sceneCode = this.wxMpApiService.parseScene(loginBody.getWxState());
        String sceneId = sceneCode.getSceneId();
        Map scanParam = (Map)this.redisCache.getCacheObject("wx:mp:scan:" + sceneId);
        if (scanParam == null) {
            return AjaxResult.error((int)508, (String)"common.qrcode.expire");
        }
        String openId = (String)scanParam.get("openid");
        String wxCode = (String)scanParam.get("code");
        String status = (String)scanParam.get("status");
        if (!"3".equals(status)) {
            return AjaxResult.error((int)503, (String)"common.qrcode.error");
        }
        String nickWx = this.wxMpApiService.reqWxUserInfo(wxCode, openId);
        return this.bindMpOpenId(loginBody.getUsername(), loginBody.getPassword(), sceneId, openId, nickWx);
    }

    private AjaxResult bindMpOpenId(String username, String password, String sceneId, String openId, String nickWx) {
        SysUser user = this.userService.selectUserByUserName(username);
        boolean match = false;
        if (user != null) {
            match = SecurityUtils.matchesPassword((String)password, (String)user.getPassword());
        }
        if (!match) {
            return AjaxResult.error((int)512, (String)"sys.pwd.unmatched");
        }
        SysUser openUser = new SysUser();
        openUser.setUserId(user.getUserId());
        openUser.setNickWx(nickWx);
        openUser.setOpenId(openId);
        this.userService.updateUserOpenId(openUser);
        return this.wxMpLogin(openId, sceneId);
    }

    private AjaxResult bindLoginMpOpenId(String sceneId, String openId, String nickWx) {
        SysUser openUser = new SysUser();
        openUser.setUserId(SecurityUtils.getUserId());
        openUser.setNickWx(nickWx);
        openUser.setOpenId(openId);
        this.userService.updateUserOpenId(openUser);
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (loginUser != null) {
            SysUser currentUser = loginUser.getUser();
            currentUser.setNickWx(nickWx);
            currentUser.setOpenId(openId);
            this.tokenService.setLoginUser(loginUser);
        }
        this.redisCache.deleteObject("wx:mp:scan:" + sceneId);
        return AjaxResult.success((Object)openUser);
    }

    public AjaxResult generateMpQr(String type) {
        LoginQr qr = this.wxMpApiService.generateMpQr(type);
        SceneCode sceneCode = this.wxMpApiService.parseScene(qr.getSceneStr());
        String sceneId = sceneCode.getSceneId();
        this.redisCache.setCacheObject("wx:mp:qrcode:" + sceneId, (Object)0, Integer.valueOf(10), TimeUnit.MINUTES);
        this.wxMpApiService.scanLoginStatus(sceneId, null, "4");
        return AjaxResult.success((Object)qr);
    }
}

