/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.dhcs.service;

import com.alibaba.fastjson2.JSON;
import com.hohunet.common.exception.ServiceException;
import com.hohunet.common.utils.sign.Base64;
import com.hohunet.dhcs.service.WxMpAccessService;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class WxMpQrService {
    private static Logger logger = LoggerFactory.getLogger(WxMpQrService.class);
    @Autowired
    private WxMpAccessService wxMpAccessService;
    @Autowired
    private RestTemplate restTemplate;
    private static final String WX_MP_QR_CREATE = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=%s";
    private static final String WX_MP_QR_SHOW = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=%s";

    public String generateBase64Qr(String sceneStr) {
        return this.mpQrBase64(this.mpQrCode(sceneStr));
    }

    private String mpQrCode(String sceneCode) {
        String encodeTicket;
        String getTicketUrl = String.format(WX_MP_QR_CREATE, this.wxMpAccessService.mpAccessToken());
        HashMap<String, Object> ticketInfo = new HashMap<String, Object>();
        ticketInfo.put("expire_seconds", 600);
        ticketInfo.put("action_name", "QR_STR_SCENE");
        HashMap<String, String> scene = new HashMap<String, String>();
        scene.put("scene_str", sceneCode);
        HashMap<String, HashMap<String, String>> actionInfo = new HashMap<String, HashMap<String, String>>();
        actionInfo.put("scene", scene);
        ticketInfo.put("action_info", actionInfo);
        ResponseEntity forEntity = this.restTemplate.postForEntity(getTicketUrl, ticketInfo, String.class, new Object[0]);
        String resp = (String)forEntity.getBody();
        if (resp == null) {
            throw new ServiceException();
        }
        String ticket = JSON.parseObject((String)resp).getString("ticket");
        try {
            encodeTicket = URLEncoder.encode(ticket, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Get wx-mp qr ticket error, sceneCode={}", (Object)sceneCode, (Object)e);
            return null;
        }
        return String.format(WX_MP_QR_SHOW, encodeTicket);
    }

    private String mpQrBase64(String qrUrl) {
        if (qrUrl == null) {
            return null;
        }
        ResponseEntity responseEntity = this.restTemplate.exchange(qrUrl, HttpMethod.GET, null, byte[].class, new Object[0]);
        byte[] body = (byte[])responseEntity.getBody();
        if (body == null) {
            logger.error("Get wx-mp qr image error, qrUrl={}", (Object)qrUrl);
            throw new ServiceException();
        }
        return Base64.encode((byte[])body);
    }
}

