/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.dhcs.service;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.hohunet.common.core.redis.RedisCache;
import com.hohunet.common.utils.StringUtils;
import com.hohunet.common.utils.sign.Base62;
import com.hohunet.common.utils.uuid.Seq;
import com.hohunet.dhcs.domain.LoginQr;
import com.hohunet.dhcs.domain.SceneCode;
import com.hohunet.dhcs.domain.TemplateMsg;
import com.hohunet.dhcs.domain.WxCfg;
import com.hohunet.dhcs.mp.IWxMpApiService;
import com.hohunet.dhcs.service.WxMpAccessService;
import com.hohunet.dhcs.service.WxMpQrService;
import com.hohunet.system.service.ISysConfigService;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class WxMpApiService
implements IWxMpApiService {
    private static Logger logger = LoggerFactory.getLogger(WxMpApiService.class);
    @Autowired
    private ISysConfigService sysConfigService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private WxMpQrService wxMpQrService;
    private static final String WX_OAUTH_TOKEN = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code";
    private static final String WX_OAUTH_USERINFO = "https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s";
    private static final String WX_MP_MSG = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=%s";
    public static final String WX_MP_QR_KEY = "wx:mp:qrcode";
    public static final String WX_MP_QR_SCAN = "wx:mp:scan";
    public static final String SCAN_UNBIND_STATUS = "1";
    public static final String SCAN_BIND_STATUS = "2";
    public static final String SCAN_GRANTED_STATUS = "3";
    public static final String QR_UN_SCAN = "4";
    public static final String QR_UNKNOWN = "5";
    @Autowired
    private WxMpAccessService wxMpAccessService;

    public String reqWxUserInfo(String wxCode, String openId) {
        String wxLoginConfig = this.sysConfigService.selectConfigByKey("sys.mp.config");
        WxCfg wxCfg = (WxCfg)JSON.parseObject((String)wxLoginConfig, WxCfg.class);
        String accessUrl = String.format(WX_OAUTH_TOKEN, wxCfg.getAppid(), wxCfg.getSecret(), wxCode);
        ResponseEntity resp = this.restTemplate.getForEntity(accessUrl, String.class, new Object[0]);
        String accessBody = (String)resp.getBody();
        if (accessBody == null) {
            logger.error("req wx access token fail!!");
            return "";
        }
        if (!resp.getStatusCode().equals(HttpStatus.OK)) {
            logger.error("req wx access token fail!! errmsg:{}", (Object)accessBody);
            return "";
        }
        JSONObject accessJson = JSON.parseObject((String)accessBody);
        String accessToken = accessJson.getString("access_token");
        String userinfoUrl = String.format(WX_OAUTH_USERINFO, accessToken, openId);
        ResponseEntity userResp = this.restTemplate.getForEntity(userinfoUrl, String.class, new Object[0]);
        String userBody = (String)userResp.getBody();
        if (userBody == null) {
            logger.error("req wx userinfo fail!!");
            return "";
        }
        if (!userResp.getStatusCode().equals(HttpStatus.OK)) {
            logger.error("req wx userinfo fail!! resp:{}", (Object)userBody);
            return "";
        }
        logger.debug("req wx userinfo {}", (Object)userBody);
        JSONObject userJson = JSON.parseObject((String)userBody);
        String nickName = userJson.getString("nickname");
        if (nickName == null) {
            return "";
        }
        nickName = new String(nickName.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        return nickName;
    }

    private String buildSceneStr(String sceneId, String type) {
        String sceneCode = sceneId + "-" + type;
        return Base62.encode((byte[])sceneCode.getBytes());
    }

    public void scanLoginStatus(String sceneStr, String openId, String status) {
        HashMap<String, String> scanBody = new HashMap<String, String>();
        scanBody.put("openid", openId);
        scanBody.put("status", status);
        this.redisCache.setCacheObject("wx:mp:scan:" + sceneStr, scanBody, Integer.valueOf(10), TimeUnit.MINUTES);
    }

    public void sendMpTemplateMsg(TemplateMsg templateMsg) {
        String getTicketUrl = String.format(WX_MP_MSG, this.wxMpAccessService.mpAccessToken());
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("touser", templateMsg.getOpenId());
        msg.put("template_id", templateMsg.getTemplateId());
        msg.put("client_msg_id", "m_" + System.currentTimeMillis());
        if (!StringUtils.isEmpty((String)templateMsg.getUrl())) {
            msg.put("url", templateMsg.getUrl());
        }
        if (templateMsg.getMiniprogram() != null) {
            msg.put("miniprogram", templateMsg.getMiniprogram());
        }
        msg.put("data", templateMsg.getContent());
        ResponseEntity forEntity = this.restTemplate.postForEntity(getTicketUrl, msg, String.class, new Object[0]);
        String resp = (String)forEntity.getBody();
        if (resp == null) {
            logger.error("send mp template msg fail!!, resp null, check network.");
        } else if (((JSONObject)JSONObject.parseObject((String)resp, JSONObject.class)).getIntValue("errcode") != 0) {
            logger.error("wx msg send fail, resp: {}", (Object)resp);
        }
    }

    public LoginQr generateMpQr(String type) {
        String sceneId = Seq.getId();
        String sceneStr = this.buildSceneStr(sceneId, type);
        LoginQr qr = new LoginQr();
        qr.setQrCode(this.wxMpQrService.generateBase64Qr(sceneStr));
        qr.setSceneStr(sceneStr);
        this.redisCache.setCacheObject("wx:mp:qrcode:" + sceneId, (Object)0, Integer.valueOf(10), TimeUnit.MINUTES);
        this.scanLoginStatus(sceneId, null, QR_UN_SCAN);
        return qr;
    }

    public SceneCode parseScene(String sceneStr) {
        String deScene = new String(Base62.decode((String)sceneStr));
        String[] scenePair = deScene.split("-");
        SceneCode sceneCode = new SceneCode();
        sceneCode.setSceneId(scenePair[0]);
        sceneCode.setType(scenePair[1]);
        return sceneCode;
    }
}

