/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.dhcs.service;

import com.alibaba.fastjson2.JSON;
import com.hohunet.common.core.redis.RedisCache;
import com.hohunet.common.exception.ServiceException;
import com.hohunet.dhcs.domain.WxCfg;
import com.hohunet.system.service.ISysConfigService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class WxMpAccessService {
    @Autowired
    private ISysConfigService sysConfigService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RedisCache redisCache;
    private static final String WX_MP_API_TOKEN = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
    private static final String WX_JSON_TICKET = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=jsapi";
    private static final String WX_MP_TOKEN_KEY = "wx:mp:token";
    private static final String WX_JS_TICKET_KEY = "wx:js:ticket";

    public String mpAccessToken() {
        String mpToken = (String)this.redisCache.getCacheObject(WX_MP_TOKEN_KEY);
        if (mpToken == null) {
            String wxLoginConfig = this.sysConfigService.selectConfigByKey("sys.mp.config");
            WxCfg wxCfg = (WxCfg)JSON.parseObject((String)wxLoginConfig, WxCfg.class);
            ResponseEntity forEntity = this.restTemplate.getForEntity(String.format(WX_MP_API_TOKEN, wxCfg.getAppid(), wxCfg.getSecret()), String.class, new Object[0]);
            String resp = (String)forEntity.getBody();
            if (resp == null) {
                throw new ServiceException();
            }
            mpToken = JSON.parseObject((String)resp).getString("access_token");
            this.redisCache.setCacheObject(WX_MP_TOKEN_KEY, (Object)mpToken, Integer.valueOf(90), TimeUnit.MINUTES);
        }
        return mpToken;
    }

    public String wxJsTicket() {
        String jsTick = (String)this.redisCache.getCacheObject(WX_JS_TICKET_KEY);
        if (jsTick == null) {
            ResponseEntity forEntity = this.restTemplate.getForEntity(String.format(WX_JSON_TICKET, this.mpAccessToken()), String.class, new Object[0]);
            String resp = (String)forEntity.getBody();
            if (resp == null) {
                throw new ServiceException();
            }
            jsTick = JSON.parseObject((String)resp).getString("ticket");
            if (jsTick != null) {
                this.redisCache.setCacheObject(WX_MP_TOKEN_KEY, (Object)jsTick, Integer.valueOf(90), TimeUnit.MINUTES);
            }
        }
        return jsTick;
    }
}

