/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.dhcs.service;

import com.alibaba.fastjson2.JSON;
import com.hohunet.common.ApplicationInfo;
import com.hohunet.common.core.domain.WxMsg;
import com.hohunet.common.core.domain.entity.SysUser;
import com.hohunet.common.core.redis.RedisCache;
import com.hohunet.common.utils.RandomUtils;
import com.hohunet.common.utils.sign.Base62;
import com.hohunet.common.utils.wx.WxMsgUtils;
import com.hohunet.common.utils.wx.WxTokenUtils;
import com.hohunet.dhcs.domain.SceneCode;
import com.hohunet.dhcs.domain.WxCfg;
import com.hohunet.dhcs.domain.WxJsConfig;
import com.hohunet.dhcs.mp.IWxMpApiService;
import com.hohunet.dhcs.service.WxMpAccessService;
import com.hohunet.system.service.ISysConfigService;
import com.hohunet.system.service.ISysUserService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxCallbackService {
    private static Logger logger = LoggerFactory.getLogger(WxCallbackService.class);
    @Autowired
    private ISysUserService userService;
    @Autowired
    private ISysConfigService sysConfigService;
    @Autowired
    private WxMpAccessService wxMpAccessService;
    @Autowired
    private IWxMpApiService wxMpApiService;
    @Autowired
    private RedisCache redisCache;
    private static final String WX_OAUTH_CODE = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=snsapi_userinfo&state=%s#wechat_redirect&forcePopup=true";
    private static final String WX_MP_QR_KEY = "wx:mp:qrcode";
    public static final String WX_MP_QR_SCAN = "wx:mp:scan";
    private static final String QR_UNKNOWN = "5";

    public String recWxMpMsg(HttpServletRequest request) {
        Map xmlMessage;
        String message = "success";
        try {
            xmlMessage = WxMsgUtils.xmlToMap((HttpServletRequest)request);
        }
        catch (IOException | DocumentException e) {
            return message;
        }
        String msgType = (String)xmlMessage.get("MsgType");
        if ("event".equals(msgType)) {
            return this.scanEvent(xmlMessage);
        }
        return "success";
    }

    private String scanEvent(Map<String, String> xmlMessage) {
        WxMsg respMsg = new WxMsg();
        String openId = xmlMessage.get("FromUserName");
        String toUserName = xmlMessage.get("ToUserName");
        respMsg.setToUserName(openId);
        respMsg.setFromUserName(toUserName);
        String success = "success";
        String eventType = xmlMessage.get("Event");
        if ("subscribe".equals(eventType) || "SCAN".equals(eventType)) {
            String eventKey = xmlMessage.get("EventKey");
            String sceneStr = eventKey.replace("qrscene_", "");
            SceneCode sceneCode = this.parseScene(sceneStr);
            String sceneId = sceneCode.getSceneId();
            String qrCodeKey = "wx:mp:qrcode:" + sceneId;
            if (this.redisCache.hasKey(qrCodeKey).booleanValue()) {
                this.redisCache.deleteObject(qrCodeKey);
                SysUser user = this.userService.selectUserByOpenId(openId);
                if (user != null) {
                    this.wxMpApiService.scanLoginStatus(sceneId, openId, "2");
                } else {
                    respMsg.setContent(this.buildUserGrantMsg(sceneCode, sceneStr, openId, sceneCode.getType()));
                }
            } else {
                this.wxMpApiService.scanLoginStatus(sceneId, null, QR_UNKNOWN);
            }
            if (respMsg.getContent() != null) {
                return WxMsgUtils.buildWxTextMsg((WxMsg)respMsg);
            }
        }
        return success;
    }

    private String buildUserGrantMsg(SceneCode sceneCode, String sceneStr, String openId, String type) {
        String redirectUri = String.format("%s/wx/oauth", ApplicationInfo.apiAddress());
        String wxLoginConfig = this.sysConfigService.selectConfigByKey("sys.mp.config");
        WxCfg wxCfg = (WxCfg)JSON.parseObject((String)wxLoginConfig, WxCfg.class);
        if (wxCfg == null) {
            logger.error("wx appid is null!!");
            return "E:6006";
        }
        this.wxMpApiService.scanLoginStatus(sceneCode.getSceneId(), openId, "1");
        redirectUri = URLEncoder.encode(redirectUri, StandardCharsets.UTF_8);
        String authUrl = String.format(WX_OAUTH_CODE, wxCfg.getAppid(), redirectUri, sceneStr);
        return String.format("\u60a8\u7684\u5fae\u4fe1\u8fd8\u672a\u7ed1\u5b9a\u5e73\u53f0\u8d26\u53f7\uff0c\u8bf7<a href='%s'>\u540c\u610f\u6388\u6743</a>\u8fdb\u884c\u7ed1\u5b9a\u3002", authUrl);
    }

    private SceneCode parseScene(String sceneStr) {
        String deScene = new String(Base62.decode((String)sceneStr));
        String[] scenePair = deScene.split("-");
        SceneCode sceneCode = new SceneCode();
        sceneCode.setSceneId(scenePair[0]);
        sceneCode.setType(scenePair[1]);
        return sceneCode;
    }

    public void wxOauth(String code, String state, HttpServletResponse response) {
        SceneCode sceneCode = this.parseScene(state);
        String sceneId = sceneCode.getSceneId();
        Map scanParam = (Map)this.redisCache.getCacheObject("wx:mp:scan:" + sceneId);
        if (scanParam == null) {
            logger.error("wx oauth expire, sceneId={}", (Object)sceneId);
            this.authRedirect(response, "202");
            return;
        }
        scanParam.put("status", "3");
        scanParam.put("code", code);
        this.redisCache.setCacheObject("wx:mp:scan:" + sceneId, (Object)scanParam, Integer.valueOf(10), TimeUnit.MINUTES);
        this.authRedirect(response, "200");
    }

    private void authRedirect(HttpServletResponse response, String code) {
        try {
            response.sendRedirect(String.format("%s/wx_auth_call.html?code=%s", ApplicationInfo.webAddress(), code));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public WxJsConfig wxJsConfig(String url) {
        WxJsConfig wxJsConfig = new WxJsConfig();
        String jsTicket = this.wxMpAccessService.wxJsTicket();
        String noncestr = RandomUtils.genRandomStr((String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789", (int)17);
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String stringBuilder = "jsapi_ticket=" + jsTicket + "&noncestr=" + noncestr + "&timestamp=" + timestamp + "&url=" + url;
        String signature = WxTokenUtils.SHA1((String)stringBuilder);
        String wxLoginConfig = this.sysConfigService.selectConfigByKey("sys.mp.config");
        WxCfg wxCfg = (WxCfg)JSON.parseObject((String)wxLoginConfig, WxCfg.class);
        wxJsConfig.setAppId(wxCfg.getAppid());
        wxJsConfig.setNoncestr(noncestr);
        wxJsConfig.setTimestamp(timestamp);
        wxJsConfig.setSignature(signature);
        return wxJsConfig;
    }
}

