/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet.dhcs.controller;

import com.hohunet.common.utils.wx.WxTokenUtils;
import com.hohunet.dhcs.domain.WxJsConfig;
import com.hohunet.dhcs.service.WxCallbackService;
import com.hohunet.system.service.ISysConfigService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WxCallbackController {
    @Autowired
    private ISysConfigService sysConfigService;
    @Autowired
    private WxCallbackService wxCallbackService;

    @Operation(description="\u5fae\u4fe1\u516c\u4f17\u53f7\u5e73\u53f0\u68c0\u67e5\u670d\u52a1\u5668\u7b7e\u540dToken(WX\u8c03\u7528)")
    @GetMapping(value={"/wx/callback"})
    @ResponseBody
    public String checkSign(HttpServletRequest request) {
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String echoStr = request.getParameter("echostr");
        String mpToken = this.sysConfigService.selectConfigByKey("sys.mp.token");
        if (WxTokenUtils.checkSignature((String)mpToken, (String)signature, (String)timestamp, (String)nonce)) {
            return echoStr;
        }
        return "";
    }

    @Operation(description="\u5fae\u4fe1\u516c\u4f17\u53f7\u5e73\u53f0\u8f6c\u53d1\u8fc7\u6765\u7684\u901a\u77e5\u548c\u6d88\u606f(WX\u8c03\u7528)")
    @PostMapping(value={"/wx/callback"})
    @ResponseBody
    public String recWxMpMsg(HttpServletRequest request) throws UnsupportedEncodingException {
        request.setCharacterEncoding("UTF-8");
        return this.wxCallbackService.recWxMpMsg(request);
    }

    @Operation(description="\u5fae\u4fe1Oauth\u6388\u6743\u7801\u56de\u8c03(WX\u8c03\u7528)")
    @GetMapping(value={"/wx/oauth"})
    public void wxOauth(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        request.setCharacterEncoding("UTF-8");
        String code = request.getParameter("code");
        String state = request.getParameter("state");
        this.wxCallbackService.wxOauth(code, state, response);
    }

    @Operation(description="\u5fae\u4fe1JS-SDK\u914d\u7f6e(\u6388\u6743\u540e\u7684\u91cd\u5b9a\u5411\u9875\u9762\u8c03\u7528\uff0c\u7528\u4e8e\u5173\u95ed\u6388\u6743\u9875\u9762\u8df3\u56de\u5fae\u4fe1\u5bf9\u8bdd\u6846)\uff0curl\u4e0d\u652f\u6301\u5305\u542b#")
    @GetMapping(value={"/wx/jsconfig"})
    public WxJsConfig wxJsConfig(String url) {
        return this.wxCallbackService.wxJsConfig(url);
    }
}

