/*
 * Decompiled with CFR 0.152.
 */
package com.hohunet;

import com.hohunet.common.mybatis.tenant.helper.TenantHelper;
import com.hohunet.quartz.mapper.SysJobLogMapper;
import com.hohunet.system.mapper.SysOperLogMapper;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClearLogExecutor
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ClearLogExecutor.class);
    @Autowired
    private SysJobLogMapper jobLogMapper;
    @Autowired
    private SysOperLogMapper sysOperLogMapper;
    @Autowired
    private ScheduledExecutorService scheduledExecutorService;

    public void afterPropertiesSet() throws Exception {
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                this.executePlans();
            }
            catch (Exception e) {
                log.error("clear log schedule execuse error!!", (Throwable)e);
            }
        }, 10L, 86400L, TimeUnit.SECONDS);
    }

    private void executePlans() {
        this.jobLogMapper.deleteLogsBefore();
        TenantHelper.ignoreTenantEnv(() -> this.sysOperLogMapper.deleteOperLogBefore());
    }
}

